require 'rubygems'
require 'page-object'
require 'page-object/page_factory'
require 'watir-webdriver'
require_relative '../../spec/rspec_helper'

class Base
  include PageObject
  def initialize(driver)
    @driver = driver
    super(driver)
  end

  #app title
  h1(:title, :css => '.ui-title' )

  #primary title
  h2(:primary_header, :css => '.primary-header h2')
  #secondary title
  h2(:secondary_header, :css=>'.secondary-header h2')

  #App Options Menu
  button(:appMenu, :id=> 'menu-btn')

  #user Menu
  button(:userMenu, :id => 'user-menu-btn')

  #footer
  span(:footerUserInfo, :id => 'user-info')
  span(:appVersion, :id => 'app-version')

  #back button
  button(:back_btn, :id => 'back-btn')
  span(:back_label, :css=>'#back-btn .phone-hidden')

  #spinner
  #div(:spinner, :css=>'.loaderModalMask')

  def getFocusedElement()
    return element_with_focus
  end

  def selectOption(elements, element_text)
    elements.each do |g|
      if g.text == element_text
        g.click
        break
      end
    end

  end

  def compareContents(expected_content, actual_content)
    expected_content.each_with_index do |expectedScreenRow, i|
      expect(actual_content[i].to_s.strip).to include(expectedScreenRow.to_s.strip)
    end
  end

end